// ============================================================
// NAVTCC SEO Tool — LLM Provider Configs
// Created by Jawad with help of AI
// ============================================================

const LLM_PROVIDERS = {

    groq_70b: {
        id:           'groq_70b',
        name:         'Groq Llama 70B',
        emoji:        '🚀',
        url:          'https://api.groq.com/openai/v1/chat/completions',
        model:        'llama-3.3-70b-versatile',
        keyStorage:   'navtcc_key_groq',
        keyPrefix:    'gsk_',
        format:       'openai',
        tokensPerMin: 6000,
        tokensPerDay: 131072,
        maxTokens:    4096,
        priority:     1,
        quality:      5,
        speed:        5,
        label:        'Free · 14.4K req/day · Fastest',
    },

    groq_8b: {
        id:           'groq_8b',
        name:         'Groq Llama 8B',
        emoji:        '⚡',
        url:          'https://api.groq.com/openai/v1/chat/completions',
        model:        'llama-3.1-8b-instant',
        keyStorage:   'navtcc_key_groq',   // same key as 70b
        keyPrefix:    'gsk_',
        format:       'openai',
        tokensPerMin: 20000,
        tokensPerDay: 131072,
        maxTokens:    4096,
        priority:     4,   // fallback when 70b rate limited
        quality:      3,
        speed:        5,
        label:        'Free · High rate limit · Ultra fast',
    },

    gemini_flash: {
        id:           'gemini_flash',
        name:         'Gemini 2.0 Flash',
        emoji:        '🔷',
        url:          'https://generativelanguage.googleapis.com/v1beta/models/gemini-2.0-flash:generateContent',
        model:        'gemini-2.0-flash',
        keyStorage:   'navtcc_key_gemini',
        keyPrefix:    'AIza',
        format:       'gemini',
        tokensPerMin: 100000,
        tokensPerDay: 1000000,
        maxTokens:    4096,
        priority:     2,
        quality:      4,
        speed:        4,
        label:        'Free · 1M tokens/day · Google',
    },

    openrouter_deepseek: {
        id:           'openrouter_deepseek',
        name:         'DeepSeek R1 Free',
        emoji:        '🐋',
        url:          'https://openrouter.ai/api/v1/chat/completions',
        model:        'deepseek/deepseek-r1:free',
        keyStorage:   'navtcc_key_openrouter',
        keyPrefix:    'sk-or-',
        format:       'openai',
        tokensPerMin: 20000,
        tokensPerDay: 200000,
        maxTokens:    4096,
        priority:     3,
        quality:      5,
        speed:        3,
        label:        'Free · Best quality · OpenRouter',
        extraHeaders: { 'HTTP-Referer': window.location.origin, 'X-Title': 'NAVTCC SEO Tool' },
    },

    openrouter_gemini: {
        id:           'openrouter_gemini',
        name:         'Gemini Flash (OpenRouter)',
        emoji:        '🌐',
        url:          'https://openrouter.ai/api/v1/chat/completions',
        model:        'google/gemini-2.0-flash-exp:free',
        keyStorage:   'navtcc_key_openrouter',  // same key as deepseek
        keyPrefix:    'sk-or-',
        format:       'openai',
        tokensPerMin: 20000,
        tokensPerDay: 200000,
        maxTokens:    4096,
        priority:     5,
        quality:      4,
        speed:        4,
        label:        'Free · Via OpenRouter',
        extraHeaders: { 'HTTP-Referer': window.location.origin, 'X-Title': 'NAVTCC SEO Tool' },
    },
};

// Keys that map to UI tabs
const KEY_TABS = {
    groq:        { storage: 'navtcc_key_groq',        prefix: 'gsk_',    providers: ['groq_70b','groq_8b'] },
    gemini:      { storage: 'navtcc_key_gemini',       prefix: 'AIza',    providers: ['gemini_flash'] },
    openrouter:  { storage: 'navtcc_key_openrouter',   prefix: 'sk-or-',  providers: ['openrouter_deepseek','openrouter_gemini'] },
};
