// ============================================================
// NAVTCC SEO Tool — Business Type Templates
// Created by Jawad with help of AI
// ============================================================

const BIZ_TEMPLATES = {
    dental: {
        type:     'Dental Clinic',
        services: 'Teeth Whitening, Dental Braces, Root Canal, Dental Implants, Teeth Cleaning, Checkup & X-Ray',
        tagline:  'Your Perfect Smile Starts Here',
        keywords: 'best dentist lahore, dental clinic lahore, teeth whitening lahore, affordable dentist lahore',
        hours:    'Mon-Sat 9AM-7PM',
        about:    'We have been serving patients since 2010 with experienced dentists, modern equipment, and affordable rates.',
        schema:   'Dentist',
        theme:    'corporate',
        color:    '#1a56db',
    },
    restaurant: {
        type:     'Restaurant',
        services: 'Dine-In, Takeaway, Home Delivery, Catering, Private Events, BBQ Nights',
        tagline:  'Authentic Flavors, Unforgettable Experience',
        keywords: 'best restaurant lahore, desi food lahore, family restaurant lahore, bbq lahore',
        hours:    'Daily 12PM-12AM',
        about:    'Family restaurant serving authentic Pakistani cuisine since 2008, famous for our BBQ and karahi.',
        schema:   'Restaurant',
        theme:    'warm',
        color:    '#b45309',
    },
    salon: {
        type:     'Beauty Salon',
        services: 'Hair Cut & Color, Facial, Manicure & Pedicure, Bridal Makeup, Threading, Hair Smoothening',
        tagline:  'Look Beautiful, Feel Confident',
        keywords: 'best beauty salon lahore, hair salon lahore, bridal makeup lahore, ladies salon lahore',
        hours:    'Mon-Sat 10AM-8PM',
        about:    'Premium beauty salon with certified stylists, offering the latest trends in hair and beauty treatments.',
        schema:   'BeautySalon',
        theme:    'vibrant',
        color:    '#db2777',
    },
    law: {
        type:     'Law Firm',
        services: 'Family Law, Property Cases, Criminal Defense, Business Law, Civil Litigation, Legal Consultation',
        tagline:  'Justice Is Our Mission',
        keywords: 'best lawyer lahore, law firm lahore, property lawyer lahore, family court lawyer lahore',
        hours:    'Mon-Sat 9AM-6PM',
        about:    'Experienced legal team with 15+ years handling complex cases across all courts in Pakistan.',
        schema:   'LegalService',
        theme:    'corporate',
        color:    '#1a1f4e',
    },
    gym: {
        type:     'Gym & Fitness Center',
        services: 'Personal Training, Weight Training, Cardio Zone, Yoga Classes, Nutrition Coaching, Steam & Sauna',
        tagline:  'Transform Your Body, Transform Your Life',
        keywords: 'best gym lahore, fitness center lahore, personal trainer lahore, gym membership lahore',
        hours:    'Daily 6AM-10PM',
        about:    'State-of-the-art fitness center with certified trainers, modern equipment, and customized fitness plans.',
        schema:   'ExerciseGym',
        theme:    'vibrant',
        color:    '#7c3aed',
    },
    school: {
        type:     'School & Academy',
        services: 'Primary Education, Secondary Education, O-Levels, A-Levels, Computer Lab, Extra-Curricular Activities',
        tagline:  'Shaping Tomorrow\'s Leaders Today',
        keywords: 'best school lahore, private school lahore, o level school lahore, english medium school lahore',
        hours:    'Mon-Sat 8AM-2PM',
        about:    'CAIE affiliated school offering modern education with experienced faculty and technology-integrated classrooms.',
        schema:   'EducationalOrganization',
        theme:    'corporate',
        color:    '#0369a1',
    },
    hospital: {
        type:     'Medical Clinic',
        services: 'General Consultation, Blood Tests, ECG, X-Ray, Ultrasound, Vaccination, Emergency Care',
        tagline:  'Your Health Is Our Priority',
        keywords: 'best clinic lahore, medical clinic lahore, doctor lahore, general physician lahore',
        hours:    'Daily 9AM-9PM',
        about:    'Multi-specialty clinic with experienced doctors, modern diagnostic equipment, and affordable healthcare.',
        schema:   'MedicalClinic',
        theme:    'corporate',
        color:    '#0f766e',
    },
    realestate: {
        type:     'Real Estate Agency',
        services: 'Residential Properties, Commercial Properties, Plot Sales, Property Management, Rental Services, Investment Advice',
        tagline:  'Your Dream Property Awaits',
        keywords: 'property dealer lahore, real estate lahore, plots for sale lahore, house for sale lahore',
        hours:    'Mon-Sat 10AM-7PM',
        about:    'Trusted real estate agency with 10+ years experience, specializing in DHA, Bahria Town, and Gulberg properties.',
        schema:   'RealEstateAgent',
        theme:    'corporate',
        color:    '#c9a84c',
    },
    hvac: {
        type:     'HVAC Services',
        services: 'AC Installation, AC Repair, AC Maintenance, Ducting, Heating Systems, Split AC, Central AC',
        tagline:  'Keeping You Cool All Year Round',
        keywords: 'ac repair lahore, hvac services lahore, ac installation lahore, ac maintenance lahore',
        hours:    'Daily 8AM-8PM',
        about:    'Professional HVAC technicians with 8+ years experience, serving residential and commercial clients across Lahore.',
        schema:   'HomeAndConstructionBusiness',
        theme:    'vibrant',
        color:    '#0ea5e9',
    },
    hotel: {
        type:     'Hotel & Guest House',
        services: 'Standard Rooms, Deluxe Rooms, Conference Hall, Restaurant, Airport Pickup, WiFi, Laundry',
        tagline:  'Your Home Away From Home',
        keywords: 'hotel lahore, guest house lahore, affordable hotel lahore, budget hotel lahore',
        hours:    'Open 24/7',
        about:    'Comfortable and affordable hotel in the heart of Lahore, perfect for business travelers and families.',
        schema:   'Hotel',
        theme:    'warm',
        color:    '#92400e',
    },
    pharmacy: {
        type:     'Pharmacy',
        services: 'Prescription Medicines, OTC Medicines, Vitamins & Supplements, Medical Devices, Home Delivery, 24/7 Service',
        tagline:  'Your Health, Our Responsibility',
        keywords: 'pharmacy lahore, medicine shop lahore, 24 hour pharmacy lahore, online pharmacy lahore',
        hours:    'Open 24/7',
        about:    'Licensed pharmacy with qualified pharmacists, offering genuine medicines and free home delivery.',
        schema:   'Pharmacy',
        theme:    'corporate',
        color:    '#059669',
    },
    transport: {
        type:     'Transport & Rent a Car',
        services: 'Self Drive Cars, Chauffeur Service, Airport Transfers, Corporate Transport, Monthly Rental, Long Route',
        tagline:  'Travel Comfortably, Travel Safely',
        keywords: 'rent a car lahore, car rental lahore, airport transfer lahore, corporate transport lahore',
        hours:    'Open 24/7',
        about:    'Reliable rent a car service with GPS-equipped vehicles, professional drivers, and competitive rates.',
        schema:   'LocalBusiness',
        theme:    'vibrant',
        color:    '#1d4ed8',
    },
};

// ── Load business template into form ─────────────────────────
function loadBizTemplate(type) {
    const t = BIZ_TEMPLATES[type];
    if (!t) return;

    // Highlight selected card
    document.querySelectorAll('.biz-type-card').forEach(c => c.classList.remove('active'));
    event.currentTarget.classList.add('active');

    // Fill form fields
    document.getElementById('bizType').value     = t.type;
    document.getElementById('bizServices').value = t.services;
    document.getElementById('bizTagline').value  = t.tagline;
    document.getElementById('bizKeywords').value = t.keywords;
    document.getElementById('bizHours').value    = t.hours;
    document.getElementById('bizAbout').value    = t.about;
    document.getElementById('bizColor').value    = t.color;
    document.getElementById('bizColorHex').value = t.color;

    // Set theme
    const themeCard = document.querySelector(`[data-theme="${t.theme}"]`);
    if (themeCard) selectTheme(themeCard, t.theme);

    // Focus on business name so user fills it next
    document.getElementById('bizName').focus();
    document.getElementById('bizName').placeholder = `e.g. Your ${t.type} Name`;

    // Scroll to form
    document.getElementById('bizName').scrollIntoView({ behavior: 'smooth', block: 'center' });

    // Show feedback
    showTemplateLoaded(t.type);
}

function showTemplateLoaded(typeName) {
    const banner = document.getElementById('learnModeBanner');
    const msg = document.createElement('div');
    msg.style.cssText = 'position:fixed;top:80px;right:20px;background:var(--green);color:#07080f;padding:12px 18px;border-radius:8px;font-size:13px;font-weight:700;font-family:var(--font-mono);z-index:999;box-shadow:0 4px 20px rgba(0,0,0,0.3)';
    msg.textContent = `✓ ${typeName} template loaded — add business name & city!`;
    document.body.appendChild(msg);
    setTimeout(() => msg.remove(), 3000);
}

// ── SEO Learn Mode toggle ─────────────────────────────────────
let learnModeOn = false;

function toggleLearnMode() {
    learnModeOn = !learnModeOn;
    const btn    = document.getElementById('btnLearnMode');
    const banner = document.getElementById('learnModeBanner');

    if (learnModeOn) {
        document.body.classList.add('learn-mode');
        btn.textContent = '💡 SEO Learn Mode: ON';
        btn.classList.add('learn-mode-active');
        banner.style.display = 'block';
    } else {
        document.body.classList.remove('learn-mode');
        btn.textContent = '💡 SEO Learn Mode: OFF';
        btn.classList.remove('learn-mode-active');
        banner.style.display = 'none';
    }
}
